param (
    [string]$PfxPath1,
    [string]$PfxPath2,    
[string]$PfxPath3,
    [string]$AppIdAuto = "{00112233-4457-6677-8899-aabbccddeeff}",
 [string]$AppIdAutoa = "{00112233-5566-6677-8899-aabbccddeeff}",    
[string]$AppIdAuto1 = "{00112233-4437-6677-8899-aabbccddeeff}",
 [string]$AppIdAutoa1 = "{00112233-57466-6677-8899-aabbccddeeff}",
    [string]$AppIdHonor = "{11112222-3333-4444-5555-666677778888}"
)


function Install-CertificateAndBind2 {
    param (
        [string]$PfxPath,
        [string]$PfxPassword,
        [string]$DnsName,
        [string]$AppId
    )

    Write-Host "`n🔐 Installing certificate for $DnsName..." -ForegroundColor Cyan

    if ([string]::IsNullOrWhiteSpace($PfxPassword)) {
        $cert = Import-PfxCertificate -FilePath $PfxPath -CertStoreLocation "Cert:\LocalMachine\My"
    } else {
        $securePwd = ConvertTo-SecureString -String $PfxPassword -AsPlainText -Force
        $cert = Import-PfxCertificate -FilePath $PfxPath -CertStoreLocation "Cert:\LocalMachine\My" -Password $securePwd
    }

    # 루트 인증서에도 설치
    Write-Host "🛡️ Adding certificate to Trusted Root Certification Authorities..." -ForegroundColor Cyan

    if ([string]::IsNullOrWhiteSpace($PfxPassword)) {
        Import-PfxCertificate -FilePath $PfxPath -CertStoreLocation "Cert:\LocalMachine\Root" | Out-Null
    } else {
        Import-PfxCertificate -FilePath $PfxPath -CertStoreLocation "Cert:\LocalMachine\Root" -Password $securePwd | Out-Null
    }

    if (-not $cert) {
        Write-Error "❌ Failed to import certificate for $DnsName."
        return
    }

    $thumbprint = $cert.Thumbprint
    Write-Host "✅ Certificate installed with thumbprint: $thumbprint" -ForegroundColor Green

    # 기존 hostnameport 바인딩 제거
    netsh http delete sslcert hostnameport=api.honorlink.org:443 > $null 2>&1
    netsh http delete urlacl url=https://api.honorlink.org:443/ > $null 2>&1

    # SSL 바인딩 (도메인 기반, SNI 방식)
    netsh http add sslcert hostnameport=api.honorlink.org:443 certhash=$thumbprint appid=$AppId certstore=MY | Out-Host

    # URL 예약
netsh http add urlacl url=https://api.honorlink.org:443/ user="Everyone"

    # hosts 등록
    $hostsPath = "$env:SystemRoot\System32\drivers\etc\hosts"
    $entry = "127.0.0.1 $DnsName"

    if (-not (Test-Path $hostsPath)) {
        Write-Host "📄 hosts 파일이 존재하지 않아 새로 생성합니다..." -ForegroundColor Yellow
        New-Item -Path $hostsPath -ItemType File -Force | Out-Null
    }

    $existing = Get-Content $hostsPath -ErrorAction Stop
    if ($existing -notcontains $entry) {
        Add-Content -Path $hostsPath -Value "`n$entry"
        Write-Host "✅ hosts 항목이 추가되었습니다: $entry" -ForegroundColor Green
    } else {
        Write-Host "ℹ️ hosts 항목이 이미 존재합니다: $entry" -ForegroundColor Gray
    }
}
function Install-CertificateAndBind3 {
    param (
        [string]$PfxPath,
        [string]$PfxPassword,
        [string]$DnsName,
        [string]$AppId
    )

    Write-Host "`n🔐 Installing certificate for $DnsName..." -ForegroundColor Cyan

    if ([string]::IsNullOrWhiteSpace($PfxPassword)) {
        $cert = Import-PfxCertificate -FilePath $PfxPath -CertStoreLocation "Cert:\LocalMachine\My"
    } else {
        $securePwd = ConvertTo-SecureString -String $PfxPassword -AsPlainText -Force
        $cert = Import-PfxCertificate -FilePath $PfxPath -CertStoreLocation "Cert:\LocalMachine\My" -Password $securePwd
    }

    # 루트 인증서에도 설치
    Write-Host "🛡️ Adding certificate to Trusted Root Certification Authorities..." -ForegroundColor Cyan

    if ([string]::IsNullOrWhiteSpace($PfxPassword)) {
        Import-PfxCertificate -FilePath $PfxPath -CertStoreLocation "Cert:\LocalMachine\Root" | Out-Null
    } else {
        Import-PfxCertificate -FilePath $PfxPath -CertStoreLocation "Cert:\LocalMachine\Root" -Password $securePwd | Out-Null
    }

    if (-not $cert) {
        Write-Error "❌ Failed to import certificate for $DnsName."
        return
    }

    $thumbprint = $cert.Thumbprint
    Write-Host "✅ Certificate installed with thumbprint: $thumbprint" -ForegroundColor Green

    # 기존 hostnameport 바인딩 제거
    netsh http delete sslcert hostnameport=au-366.com:443 > $null 2>&1
    netsh http delete urlacl url=https://au-366.com:443/ > $null 2>&1
   netsh http delete sslcert hostnameport=au-366.com:2053 > $null 2>&1
    netsh http delete urlacl url=https://au-366.com:2053/ > $null 2>&1
    # SSL 바인딩 (도메인 기반, SNI 방식)
    netsh http add sslcert hostnameport=au-366.com:443 certhash=$thumbprint appid=$AppIdAuto1 certstore=MY | Out-Host
netsh http add sslcert hostnameport=au-366.com:2053 certhash=$thumbprint appid=$AppIdAutoa1 certstore=MY | Out-Host
    # URL 예약
netsh http add urlacl url=https://au-366.com:443/ user="Everyone"
netsh http add urlacl url=https://au-366.com:2053/ user="Everyone"

    # hosts 등록
    $hostsPath = "$env:SystemRoot\System32\drivers\etc\hosts"
    $entry = "127.0.0.1 $DnsName"

    if (-not (Test-Path $hostsPath)) {
        Write-Host "📄 hosts 파일이 존재하지 않아 새로 생성합니다..." -ForegroundColor Yellow
        New-Item -Path $hostsPath -ItemType File -Force | Out-Null
    }

    $existing = Get-Content $hostsPath -ErrorAction Stop
    if ($existing -notcontains $entry) {
        Add-Content -Path $hostsPath -Value "`n$entry"
        Write-Host "✅ hosts 항목이 추가되었습니다: $entry" -ForegroundColor Green
    } else {
        Write-Host "ℹ️ hosts 항목이 이미 존재합니다: $entry" -ForegroundColor Gray
    }
}
function Install-CertificateAndBind {
    param (
        [string]$PfxPath,
        [string]$PfxPassword,
        [string]$DnsName,
        [string]$AppId
    )

    Write-Host "`n🔐 Installing certificate for $DnsName..." -ForegroundColor Cyan

    if ([string]::IsNullOrWhiteSpace($PfxPassword)) {
        $cert = Import-PfxCertificate -FilePath $PfxPath -CertStoreLocation "Cert:\LocalMachine\My"
    } else {
        $securePwd = ConvertTo-SecureString -String $PfxPassword -AsPlainText -Force
        $cert = Import-PfxCertificate -FilePath $PfxPath -CertStoreLocation "Cert:\LocalMachine\My" -Password $securePwd
    }

    # 루트 인증서에도 설치
    Write-Host "🛡️ Adding certificate to Trusted Root Certification Authorities..." -ForegroundColor Cyan

    if ([string]::IsNullOrWhiteSpace($PfxPassword)) {
        Import-PfxCertificate -FilePath $PfxPath -CertStoreLocation "Cert:\LocalMachine\Root" | Out-Null
    } else {
        Import-PfxCertificate -FilePath $PfxPath -CertStoreLocation "Cert:\LocalMachine\Root" -Password $securePwd | Out-Null
    }

    if (-not $cert) {
        Write-Error "❌ Failed to import certificate for $DnsName."
        return
    }

    $thumbprint = $cert.Thumbprint
    Write-Host "✅ Certificate installed with thumbprint: $thumbprint" -ForegroundColor Green

    # 기존 hostnameport 바인딩 제거
    netsh http delete sslcert hostnameport=auto-366.com:443 > $null 2>&1
    netsh http delete urlacl url=https://auto-366.com:443/ > $null 2>&1
   netsh http delete sslcert hostnameport=auto-366.com:2053 > $null 2>&1
    netsh http delete urlacl url=https://auto-366.com:2053/ > $null 2>&1
    # SSL 바인딩 (도메인 기반, SNI 방식)
    netsh http add sslcert hostnameport=auto-366.com:443 certhash=$thumbprint appid=$AppId certstore=MY | Out-Host
netsh http add sslcert hostnameport=auto-366.com:2053 certhash=$thumbprint appid=$AppIdAutoa certstore=MY | Out-Host
    # URL 예약
netsh http add urlacl url=https://auto-366.com:443/ user="Everyone"
netsh http add urlacl url=https://auto-366.com:2053/ user="Everyone"

    # hosts 등록
    $hostsPath = "$env:SystemRoot\System32\drivers\etc\hosts"
    $entry = "127.0.0.1 $DnsName"

    if (-not (Test-Path $hostsPath)) {
        Write-Host "📄 hosts 파일이 존재하지 않아 새로 생성합니다..." -ForegroundColor Yellow
        New-Item -Path $hostsPath -ItemType File -Force | Out-Null
    }

    $existing = Get-Content $hostsPath -ErrorAction Stop
    if ($existing -notcontains $entry) {
        Add-Content -Path $hostsPath -Value "`n$entry"
        Write-Host "✅ hosts 항목이 추가되었습니다: $entry" -ForegroundColor Green
    } else {
        Write-Host "ℹ️ hosts 항목이 이미 존재합니다: $entry" -ForegroundColor Gray
    }
}
Write-Host "📁 PfxPath1: $PfxPath1"
Write-Host "📁 PfxPath2: $PfxPath2"
Write-Host "📁 PfxPath3: $PfxPath3"
# 실행: auto-366.com 인증서
Install-CertificateAndBind -PfxPath $PfxPath1 -PfxPassword "" -DnsName "auto-366.com" -AppId $AppIdAuto

# 실행: api.honorlink.org 인증서
Install-CertificateAndBind2 -PfxPath $PfxPath2 -PfxPassword "" -DnsName "api.honorlink.org" -AppId $AppIdHonor

# 실행: api.honorlink.org 인증서
Install-CertificateAndBind3 -PfxPath $PfxPath3 -PfxPassword "" -DnsName "au-366.com" -AppId $AppIdAuto1

pause
